/*
 * Decompiled with CFR 0.152.
 */
package net.noiilive.hahueuh.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.noiilive.hahueuh.HahUeuhMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class HahUeuhModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        HahUeuhMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        HahUeuhMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        HahUeuhMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.ReturnHealth = message.data.ReturnHealth;
                    variables.ReturnX = message.data.ReturnX;
                    variables.ReturnY = message.data.ReturnY;
                    variables.ReturnZ = message.data.ReturnZ;
                    variables.JoinedWorld = message.data.JoinedWorld;
                    variables.SlotOffhand = message.data.SlotOffhand;
                    variables.SlotHelmet = message.data.SlotHelmet;
                    variables.SlotChestplate = message.data.SlotChestplate;
                    variables.SlotLeggings = message.data.SlotLeggings;
                    variables.SlotBoots = message.data.SlotBoots;
                    variables.Slot0 = message.data.Slot0;
                    variables.Slot1 = message.data.Slot1;
                    variables.Slot2 = message.data.Slot2;
                    variables.Slot3 = message.data.Slot3;
                    variables.Slot4 = message.data.Slot4;
                    variables.Slot5 = message.data.Slot5;
                    variables.Slot6 = message.data.Slot6;
                    variables.Slot7 = message.data.Slot7;
                    variables.Slot8 = message.data.Slot8;
                    variables.Slot9 = message.data.Slot9;
                    variables.Slot10 = message.data.Slot10;
                    variables.Slot11 = message.data.Slot11;
                    variables.Slot12 = message.data.Slot12;
                    variables.Slot13 = message.data.Slot13;
                    variables.Slot14 = message.data.Slot14;
                    variables.Slot15 = message.data.Slot15;
                    variables.Slot16 = message.data.Slot16;
                    variables.Slot17 = message.data.Slot17;
                    variables.Slot18 = message.data.Slot18;
                    variables.Slot19 = message.data.Slot19;
                    variables.Slot20 = message.data.Slot20;
                    variables.Slot21 = message.data.Slot21;
                    variables.Slot22 = message.data.Slot22;
                    variables.Slot23 = message.data.Slot23;
                    variables.Slot24 = message.data.Slot24;
                    variables.Slot25 = message.data.Slot25;
                    variables.Slot26 = message.data.Slot26;
                    variables.Slot27 = message.data.Slot27;
                    variables.Slot28 = message.data.Slot28;
                    variables.Slot29 = message.data.Slot29;
                    variables.Slot30 = message.data.Slot30;
                    variables.Slot31 = message.data.Slot31;
                    variables.Slot32 = message.data.Slot32;
                    variables.Slot33 = message.data.Slot33;
                    variables.Slot34 = message.data.Slot34;
                    variables.Slot35 = message.data.Slot35;
                    variables.OffhandAmount = message.data.OffhandAmount;
                    variables.SlotAmount0 = message.data.SlotAmount0;
                    variables.SlotAmount1 = message.data.SlotAmount1;
                    variables.SlotAmount2 = message.data.SlotAmount2;
                    variables.SlotAmount3 = message.data.SlotAmount3;
                    variables.SlotAmount4 = message.data.SlotAmount4;
                    variables.SlotAmount5 = message.data.SlotAmount5;
                    variables.SlotAmount6 = message.data.SlotAmount6;
                    variables.SlotAmount7 = message.data.SlotAmount7;
                    variables.SlotAmount8 = message.data.SlotAmount8;
                    variables.SlotAmount9 = message.data.SlotAmount9;
                    variables.SlotAmount10 = message.data.SlotAmount10;
                    variables.SlotAmount11 = message.data.SlotAmount11;
                    variables.SlotAmount12 = message.data.SlotAmount12;
                    variables.SlotAmount13 = message.data.SlotAmount13;
                    variables.SlotAmount14 = message.data.SlotAmount14;
                    variables.SlotAmount15 = message.data.SlotAmount15;
                    variables.SlotAmount16 = message.data.SlotAmount16;
                    variables.SlotAmount17 = message.data.SlotAmount17;
                    variables.SlotAmount18 = message.data.SlotAmount18;
                    variables.SlotAmount19 = message.data.SlotAmount19;
                    variables.SlotAmount20 = message.data.SlotAmount20;
                    variables.SlotAmount21 = message.data.SlotAmount21;
                    variables.SlotAmount22 = message.data.SlotAmount22;
                    variables.SlotAmount23 = message.data.SlotAmount23;
                    variables.SlotAmount24 = message.data.SlotAmount24;
                    variables.SlotAmount25 = message.data.SlotAmount25;
                    variables.SlotAmount26 = message.data.SlotAmount26;
                    variables.SlotAmount27 = message.data.SlotAmount27;
                    variables.SlotAmount28 = message.data.SlotAmount28;
                    variables.SlotAmount29 = message.data.SlotAmount29;
                    variables.SlotAmount30 = message.data.SlotAmount30;
                    variables.SlotAmount31 = message.data.SlotAmount31;
                    variables.SlotAmount32 = message.data.SlotAmount32;
                    variables.SlotAmount33 = message.data.SlotAmount33;
                    variables.SlotAmount34 = message.data.SlotAmount34;
                    variables.SlotAmount35 = message.data.SlotAmount35;
                    variables.ReturnHunger = message.data.ReturnHunger;
                    variables.ReturnByDeath = message.data.ReturnByDeath;
                    variables.DeathRisk = message.data.DeathRisk;
                    variables.Dead = message.data.Dead;
                    variables.ReturnDimension = message.data.ReturnDimension;
                    variables.ReturnMotionX = message.data.ReturnMotionX;
                    variables.ReturnMotionY = message.data.ReturnMotionY;
                    variables.ReturnMotionZ = message.data.ReturnMotionZ;
                    variables.ReturnLookX = message.data.ReturnLookX;
                    variables.ReturnLookY = message.data.ReturnLookY;
                    variables.ReturnLookZ = message.data.ReturnLookZ;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double ReturnHealth = 20.0;
        public double ReturnX = 0.0;
        public double ReturnY = 69.0;
        public double ReturnZ = 0.0;
        public boolean JoinedWorld = false;
        public ItemStack SlotOffhand = ItemStack.f_41583_;
        public ItemStack SlotHelmet = ItemStack.f_41583_;
        public ItemStack SlotChestplate = ItemStack.f_41583_;
        public ItemStack SlotLeggings = ItemStack.f_41583_;
        public ItemStack SlotBoots = ItemStack.f_41583_;
        public ItemStack Slot0 = ItemStack.f_41583_;
        public ItemStack Slot1 = ItemStack.f_41583_;
        public ItemStack Slot2 = ItemStack.f_41583_;
        public ItemStack Slot3 = ItemStack.f_41583_;
        public ItemStack Slot4 = ItemStack.f_41583_;
        public ItemStack Slot5 = ItemStack.f_41583_;
        public ItemStack Slot6 = ItemStack.f_41583_;
        public ItemStack Slot7 = ItemStack.f_41583_;
        public ItemStack Slot8 = ItemStack.f_41583_;
        public ItemStack Slot9 = ItemStack.f_41583_;
        public ItemStack Slot10 = ItemStack.f_41583_;
        public ItemStack Slot11 = ItemStack.f_41583_;
        public ItemStack Slot12 = ItemStack.f_41583_;
        public ItemStack Slot13 = ItemStack.f_41583_;
        public ItemStack Slot14 = ItemStack.f_41583_;
        public ItemStack Slot15 = ItemStack.f_41583_;
        public ItemStack Slot16 = ItemStack.f_41583_;
        public ItemStack Slot17 = ItemStack.f_41583_;
        public ItemStack Slot18 = ItemStack.f_41583_;
        public ItemStack Slot19 = ItemStack.f_41583_;
        public ItemStack Slot20 = ItemStack.f_41583_;
        public ItemStack Slot21 = ItemStack.f_41583_;
        public ItemStack Slot22 = ItemStack.f_41583_;
        public ItemStack Slot23 = ItemStack.f_41583_;
        public ItemStack Slot24 = ItemStack.f_41583_;
        public ItemStack Slot25 = ItemStack.f_41583_;
        public ItemStack Slot26 = ItemStack.f_41583_;
        public ItemStack Slot27 = ItemStack.f_41583_;
        public ItemStack Slot28 = ItemStack.f_41583_;
        public ItemStack Slot29 = ItemStack.f_41583_;
        public ItemStack Slot30 = ItemStack.f_41583_;
        public ItemStack Slot31 = ItemStack.f_41583_;
        public ItemStack Slot32 = ItemStack.f_41583_;
        public ItemStack Slot33 = ItemStack.f_41583_;
        public ItemStack Slot34 = ItemStack.f_41583_;
        public ItemStack Slot35 = ItemStack.f_41583_;
        public double OffhandAmount = 0.0;
        public double SlotAmount0 = 0.0;
        public double SlotAmount1 = 0.0;
        public double SlotAmount2 = 0.0;
        public double SlotAmount3 = 0.0;
        public double SlotAmount4 = 0.0;
        public double SlotAmount5 = 0.0;
        public double SlotAmount6 = 0.0;
        public double SlotAmount7 = 0.0;
        public double SlotAmount8 = 0.0;
        public double SlotAmount9 = 0.0;
        public double SlotAmount10 = 0.0;
        public double SlotAmount11 = 0.0;
        public double SlotAmount12 = 0.0;
        public double SlotAmount13 = 0.0;
        public double SlotAmount14 = 0.0;
        public double SlotAmount15 = 0.0;
        public double SlotAmount16 = 0.0;
        public double SlotAmount17 = 0.0;
        public double SlotAmount18 = 0.0;
        public double SlotAmount19 = 0.0;
        public double SlotAmount20 = 0.0;
        public double SlotAmount21 = 0.0;
        public double SlotAmount22 = 0.0;
        public double SlotAmount23 = 0.0;
        public double SlotAmount24 = 0.0;
        public double SlotAmount25 = 0.0;
        public double SlotAmount26 = 0.0;
        public double SlotAmount27 = 0.0;
        public double SlotAmount28 = 0.0;
        public double SlotAmount29 = 0.0;
        public double SlotAmount30 = 0.0;
        public double SlotAmount31 = 0.0;
        public double SlotAmount32 = 0.0;
        public double SlotAmount33 = 0.0;
        public double SlotAmount34 = 0.0;
        public double SlotAmount35 = 0.0;
        public double ReturnHunger = 20.0;
        public boolean ReturnByDeath = false;
        public boolean DeathRisk = false;
        public boolean Dead = false;
        public String ReturnDimension = "minecraft:overworld";
        public double ReturnMotionX = 0.0;
        public double ReturnMotionY = 0.0;
        public double ReturnMotionZ = 0.0;
        public double ReturnLookX = 0.0;
        public double ReturnLookY = 0.0;
        public double ReturnLookZ = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                HahUeuhMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("ReturnHealth", this.ReturnHealth);
            nbt.m_128347_("ReturnX", this.ReturnX);
            nbt.m_128347_("ReturnY", this.ReturnY);
            nbt.m_128347_("ReturnZ", this.ReturnZ);
            nbt.m_128379_("JoinedWorld", this.JoinedWorld);
            nbt.m_128365_("SlotOffhand", (Tag)this.SlotOffhand.m_41739_(new CompoundTag()));
            nbt.m_128365_("SlotHelmet", (Tag)this.SlotHelmet.m_41739_(new CompoundTag()));
            nbt.m_128365_("SlotChestplate", (Tag)this.SlotChestplate.m_41739_(new CompoundTag()));
            nbt.m_128365_("SlotLeggings", (Tag)this.SlotLeggings.m_41739_(new CompoundTag()));
            nbt.m_128365_("SlotBoots", (Tag)this.SlotBoots.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot0", (Tag)this.Slot0.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot1", (Tag)this.Slot1.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot2", (Tag)this.Slot2.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot3", (Tag)this.Slot3.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot4", (Tag)this.Slot4.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot5", (Tag)this.Slot5.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot6", (Tag)this.Slot6.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot7", (Tag)this.Slot7.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot8", (Tag)this.Slot8.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot9", (Tag)this.Slot9.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot10", (Tag)this.Slot10.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot11", (Tag)this.Slot11.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot12", (Tag)this.Slot12.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot13", (Tag)this.Slot13.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot14", (Tag)this.Slot14.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot15", (Tag)this.Slot15.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot16", (Tag)this.Slot16.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot17", (Tag)this.Slot17.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot18", (Tag)this.Slot18.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot19", (Tag)this.Slot19.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot20", (Tag)this.Slot20.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot21", (Tag)this.Slot21.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot22", (Tag)this.Slot22.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot23", (Tag)this.Slot23.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot24", (Tag)this.Slot24.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot25", (Tag)this.Slot25.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot26", (Tag)this.Slot26.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot27", (Tag)this.Slot27.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot28", (Tag)this.Slot28.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot29", (Tag)this.Slot29.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot30", (Tag)this.Slot30.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot31", (Tag)this.Slot31.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot32", (Tag)this.Slot32.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot33", (Tag)this.Slot33.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot34", (Tag)this.Slot34.m_41739_(new CompoundTag()));
            nbt.m_128365_("Slot35", (Tag)this.Slot35.m_41739_(new CompoundTag()));
            nbt.m_128347_("OffhandAmount", this.OffhandAmount);
            nbt.m_128347_("SlotAmount0", this.SlotAmount0);
            nbt.m_128347_("SlotAmount1", this.SlotAmount1);
            nbt.m_128347_("SlotAmount2", this.SlotAmount2);
            nbt.m_128347_("SlotAmount3", this.SlotAmount3);
            nbt.m_128347_("SlotAmount4", this.SlotAmount4);
            nbt.m_128347_("SlotAmount5", this.SlotAmount5);
            nbt.m_128347_("SlotAmount6", this.SlotAmount6);
            nbt.m_128347_("SlotAmount7", this.SlotAmount7);
            nbt.m_128347_("SlotAmount8", this.SlotAmount8);
            nbt.m_128347_("SlotAmount9", this.SlotAmount9);
            nbt.m_128347_("SlotAmount10", this.SlotAmount10);
            nbt.m_128347_("SlotAmount11", this.SlotAmount11);
            nbt.m_128347_("SlotAmount12", this.SlotAmount12);
            nbt.m_128347_("SlotAmount13", this.SlotAmount13);
            nbt.m_128347_("SlotAmount14", this.SlotAmount14);
            nbt.m_128347_("SlotAmount15", this.SlotAmount15);
            nbt.m_128347_("SlotAmount16", this.SlotAmount16);
            nbt.m_128347_("SlotAmount17", this.SlotAmount17);
            nbt.m_128347_("SlotAmount18", this.SlotAmount18);
            nbt.m_128347_("SlotAmount19", this.SlotAmount19);
            nbt.m_128347_("SlotAmount20", this.SlotAmount20);
            nbt.m_128347_("SlotAmount21", this.SlotAmount21);
            nbt.m_128347_("SlotAmount22", this.SlotAmount22);
            nbt.m_128347_("SlotAmount23", this.SlotAmount23);
            nbt.m_128347_("SlotAmount24", this.SlotAmount24);
            nbt.m_128347_("SlotAmount25", this.SlotAmount25);
            nbt.m_128347_("SlotAmount26", this.SlotAmount26);
            nbt.m_128347_("SlotAmount27", this.SlotAmount27);
            nbt.m_128347_("SlotAmount28", this.SlotAmount28);
            nbt.m_128347_("SlotAmount29", this.SlotAmount29);
            nbt.m_128347_("SlotAmount30", this.SlotAmount30);
            nbt.m_128347_("SlotAmount31", this.SlotAmount31);
            nbt.m_128347_("SlotAmount32", this.SlotAmount32);
            nbt.m_128347_("SlotAmount33", this.SlotAmount33);
            nbt.m_128347_("SlotAmount34", this.SlotAmount34);
            nbt.m_128347_("SlotAmount35", this.SlotAmount35);
            nbt.m_128347_("ReturnHunger", this.ReturnHunger);
            nbt.m_128379_("ReturnByDeath", this.ReturnByDeath);
            nbt.m_128379_("DeathRisk", this.DeathRisk);
            nbt.m_128379_("Dead", this.Dead);
            nbt.m_128359_("ReturnDimension", this.ReturnDimension);
            nbt.m_128347_("ReturnMotionX", this.ReturnMotionX);
            nbt.m_128347_("ReturnMotionY", this.ReturnMotionY);
            nbt.m_128347_("ReturnMotionZ", this.ReturnMotionZ);
            nbt.m_128347_("ReturnLookX", this.ReturnLookX);
            nbt.m_128347_("ReturnLookY", this.ReturnLookY);
            nbt.m_128347_("ReturnLookZ", this.ReturnLookZ);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt;
            if (tag == null) {
                tag = this.writeNBT();
            }
            if ((nbt = (CompoundTag)tag) == null) {
                nbt = (CompoundTag)this.writeNBT();
            }
            this.ReturnHealth = nbt.m_128459_("ReturnHealth");
            this.ReturnX = nbt.m_128459_("ReturnX");
            this.ReturnY = nbt.m_128459_("ReturnY");
            this.ReturnZ = nbt.m_128459_("ReturnZ");
            this.JoinedWorld = nbt.m_128471_("JoinedWorld");
            this.SlotOffhand = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("SlotOffhand"));
            this.SlotHelmet = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("SlotHelmet"));
            this.SlotChestplate = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("SlotChestplate"));
            this.SlotLeggings = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("SlotLeggings"));
            this.SlotBoots = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("SlotBoots"));
            this.Slot0 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot0"));
            this.Slot1 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot1"));
            this.Slot2 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot2"));
            this.Slot3 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot3"));
            this.Slot4 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot4"));
            this.Slot5 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot5"));
            this.Slot6 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot6"));
            this.Slot7 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot7"));
            this.Slot8 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot8"));
            this.Slot9 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot9"));
            this.Slot10 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot10"));
            this.Slot11 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot11"));
            this.Slot12 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot12"));
            this.Slot13 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot13"));
            this.Slot14 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot14"));
            this.Slot15 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot15"));
            this.Slot16 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot16"));
            this.Slot17 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot17"));
            this.Slot18 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot18"));
            this.Slot19 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot19"));
            this.Slot20 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot20"));
            this.Slot21 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot21"));
            this.Slot22 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot22"));
            this.Slot23 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot23"));
            this.Slot24 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot24"));
            this.Slot25 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot25"));
            this.Slot26 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot26"));
            this.Slot27 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot27"));
            this.Slot28 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot28"));
            this.Slot29 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot29"));
            this.Slot30 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot30"));
            this.Slot31 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot31"));
            this.Slot32 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot32"));
            this.Slot33 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot33"));
            this.Slot34 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot34"));
            this.Slot35 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Slot35"));
            this.OffhandAmount = nbt.m_128459_("OffhandAmount");
            this.SlotAmount0 = nbt.m_128459_("SlotAmount0");
            this.SlotAmount1 = nbt.m_128459_("SlotAmount1");
            this.SlotAmount2 = nbt.m_128459_("SlotAmount2");
            this.SlotAmount3 = nbt.m_128459_("SlotAmount3");
            this.SlotAmount4 = nbt.m_128459_("SlotAmount4");
            this.SlotAmount5 = nbt.m_128459_("SlotAmount5");
            this.SlotAmount6 = nbt.m_128459_("SlotAmount6");
            this.SlotAmount7 = nbt.m_128459_("SlotAmount7");
            this.SlotAmount8 = nbt.m_128459_("SlotAmount8");
            this.SlotAmount9 = nbt.m_128459_("SlotAmount9");
            this.SlotAmount10 = nbt.m_128459_("SlotAmount10");
            this.SlotAmount11 = nbt.m_128459_("SlotAmount11");
            this.SlotAmount12 = nbt.m_128459_("SlotAmount12");
            this.SlotAmount13 = nbt.m_128459_("SlotAmount13");
            this.SlotAmount14 = nbt.m_128459_("SlotAmount14");
            this.SlotAmount15 = nbt.m_128459_("SlotAmount15");
            this.SlotAmount16 = nbt.m_128459_("SlotAmount16");
            this.SlotAmount17 = nbt.m_128459_("SlotAmount17");
            this.SlotAmount18 = nbt.m_128459_("SlotAmount18");
            this.SlotAmount19 = nbt.m_128459_("SlotAmount19");
            this.SlotAmount20 = nbt.m_128459_("SlotAmount20");
            this.SlotAmount21 = nbt.m_128459_("SlotAmount21");
            this.SlotAmount22 = nbt.m_128459_("SlotAmount22");
            this.SlotAmount23 = nbt.m_128459_("SlotAmount23");
            this.SlotAmount24 = nbt.m_128459_("SlotAmount24");
            this.SlotAmount25 = nbt.m_128459_("SlotAmount25");
            this.SlotAmount26 = nbt.m_128459_("SlotAmount26");
            this.SlotAmount27 = nbt.m_128459_("SlotAmount27");
            this.SlotAmount28 = nbt.m_128459_("SlotAmount28");
            this.SlotAmount29 = nbt.m_128459_("SlotAmount29");
            this.SlotAmount30 = nbt.m_128459_("SlotAmount30");
            this.SlotAmount31 = nbt.m_128459_("SlotAmount31");
            this.SlotAmount32 = nbt.m_128459_("SlotAmount32");
            this.SlotAmount33 = nbt.m_128459_("SlotAmount33");
            this.SlotAmount34 = nbt.m_128459_("SlotAmount34");
            this.SlotAmount35 = nbt.m_128459_("SlotAmount35");
            this.ReturnHunger = nbt.m_128459_("ReturnHunger");
            this.ReturnByDeath = nbt.m_128471_("ReturnByDeath");
            this.DeathRisk = nbt.m_128471_("DeathRisk");
            this.Dead = nbt.m_128471_("Dead");
            this.ReturnDimension = nbt.m_128461_("ReturnDimension");
            this.ReturnMotionX = nbt.m_128459_("ReturnMotionX");
            this.ReturnMotionY = nbt.m_128459_("ReturnMotionY");
            this.ReturnMotionZ = nbt.m_128459_("ReturnMotionZ");
            this.ReturnLookX = nbt.m_128459_("ReturnLookX");
            this.ReturnLookY = nbt.m_128459_("ReturnLookY");
            this.ReturnLookZ = nbt.m_128459_("ReturnLookZ");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("hah_ueuh", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "hah_ueuh_mapvars";
        public double CheckpointTimer = 100.0;
        public boolean Returned = false;
        public double ReturnTime = 1.0;
        public double Changes = 0.0;
        public String ChangesMade = "";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            if (nbt == null) {
                nbt = this.m_7176_(new CompoundTag());
            }
            this.CheckpointTimer = nbt.m_128459_("CheckpointTimer");
            this.Returned = nbt.m_128471_("Returned");
            this.ReturnTime = nbt.m_128459_("ReturnTime");
            this.Changes = nbt.m_128459_("Changes");
            this.ChangesMade = nbt.m_128461_("ChangesMade");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("CheckpointTimer", this.CheckpointTimer);
            nbt.m_128379_("Returned", this.Returned);
            nbt.m_128347_("ReturnTime", this.ReturnTime);
            nbt.m_128347_("Changes", this.Changes);
            nbt.m_128359_("ChangesMade", this.ChangesMade);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                HahUeuhMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "hah_ueuh_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                HahUeuhMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.ReturnHealth = original.ReturnHealth;
            clone.ReturnX = original.ReturnX;
            clone.ReturnY = original.ReturnY;
            clone.ReturnZ = original.ReturnZ;
            clone.JoinedWorld = original.JoinedWorld;
            clone.SlotOffhand = original.SlotOffhand;
            clone.SlotHelmet = original.SlotHelmet;
            clone.SlotChestplate = original.SlotChestplate;
            clone.SlotLeggings = original.SlotLeggings;
            clone.SlotBoots = original.SlotBoots;
            clone.Slot0 = original.Slot0;
            clone.Slot1 = original.Slot1;
            clone.Slot2 = original.Slot2;
            clone.Slot3 = original.Slot3;
            clone.Slot4 = original.Slot4;
            clone.Slot5 = original.Slot5;
            clone.Slot6 = original.Slot6;
            clone.Slot7 = original.Slot7;
            clone.Slot8 = original.Slot8;
            clone.Slot9 = original.Slot9;
            clone.Slot10 = original.Slot10;
            clone.Slot11 = original.Slot11;
            clone.Slot12 = original.Slot12;
            clone.Slot13 = original.Slot13;
            clone.Slot14 = original.Slot14;
            clone.Slot15 = original.Slot15;
            clone.Slot16 = original.Slot16;
            clone.Slot17 = original.Slot17;
            clone.Slot18 = original.Slot18;
            clone.Slot19 = original.Slot19;
            clone.Slot20 = original.Slot20;
            clone.Slot21 = original.Slot21;
            clone.Slot22 = original.Slot22;
            clone.Slot23 = original.Slot23;
            clone.Slot24 = original.Slot24;
            clone.Slot25 = original.Slot25;
            clone.Slot26 = original.Slot26;
            clone.Slot27 = original.Slot27;
            clone.Slot28 = original.Slot28;
            clone.Slot29 = original.Slot29;
            clone.Slot30 = original.Slot30;
            clone.Slot31 = original.Slot31;
            clone.Slot32 = original.Slot32;
            clone.Slot33 = original.Slot33;
            clone.Slot34 = original.Slot34;
            clone.Slot35 = original.Slot35;
            clone.OffhandAmount = original.OffhandAmount;
            clone.SlotAmount0 = original.SlotAmount0;
            clone.SlotAmount1 = original.SlotAmount1;
            clone.SlotAmount2 = original.SlotAmount2;
            clone.SlotAmount3 = original.SlotAmount3;
            clone.SlotAmount4 = original.SlotAmount4;
            clone.SlotAmount5 = original.SlotAmount5;
            clone.SlotAmount6 = original.SlotAmount6;
            clone.SlotAmount7 = original.SlotAmount7;
            clone.SlotAmount8 = original.SlotAmount8;
            clone.SlotAmount9 = original.SlotAmount9;
            clone.SlotAmount10 = original.SlotAmount10;
            clone.SlotAmount11 = original.SlotAmount11;
            clone.SlotAmount12 = original.SlotAmount12;
            clone.SlotAmount13 = original.SlotAmount13;
            clone.SlotAmount14 = original.SlotAmount14;
            clone.SlotAmount15 = original.SlotAmount15;
            clone.SlotAmount16 = original.SlotAmount16;
            clone.SlotAmount17 = original.SlotAmount17;
            clone.SlotAmount18 = original.SlotAmount18;
            clone.SlotAmount19 = original.SlotAmount19;
            clone.SlotAmount20 = original.SlotAmount20;
            clone.SlotAmount21 = original.SlotAmount21;
            clone.SlotAmount22 = original.SlotAmount22;
            clone.SlotAmount23 = original.SlotAmount23;
            clone.SlotAmount24 = original.SlotAmount24;
            clone.SlotAmount25 = original.SlotAmount25;
            clone.SlotAmount26 = original.SlotAmount26;
            clone.SlotAmount27 = original.SlotAmount27;
            clone.SlotAmount28 = original.SlotAmount28;
            clone.SlotAmount29 = original.SlotAmount29;
            clone.SlotAmount30 = original.SlotAmount30;
            clone.SlotAmount31 = original.SlotAmount31;
            clone.SlotAmount32 = original.SlotAmount32;
            clone.SlotAmount33 = original.SlotAmount33;
            clone.SlotAmount34 = original.SlotAmount34;
            clone.SlotAmount35 = original.SlotAmount35;
            clone.ReturnHunger = original.ReturnHunger;
            clone.ReturnByDeath = original.ReturnByDeath;
            clone.DeathRisk = original.DeathRisk;
            clone.Dead = original.Dead;
            clone.ReturnDimension = original.ReturnDimension;
            clone.ReturnMotionX = original.ReturnMotionX;
            clone.ReturnMotionY = original.ReturnMotionY;
            clone.ReturnMotionZ = original.ReturnMotionZ;
            clone.ReturnLookX = original.ReturnLookX;
            clone.ReturnLookY = original.ReturnLookY;
            clone.ReturnLookZ = original.ReturnLookZ;
            if (!event.isWasDeath()) {
                // empty if block
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    HahUeuhMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    HahUeuhMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                HahUeuhMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

