/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.step;

import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.gridList.ArrayGridList;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DhLitWorldGenRegion;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.params.ThreadWorldGenParams;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.AbstractWorldGenStep;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;

public final class StepStructureStart
extends AbstractWorldGenStep {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final ChunkStatus STATUS = ChunkStatus.f_62315_;
    private static final ReentrantLock STRUCTURE_PLACEMENT_LOCK = new ReentrantLock();
    private final BatchGenerationEnvironment environment;

    public StepStructureStart(BatchGenerationEnvironment batchGenerationEnvironment) {
        this.environment = batchGenerationEnvironment;
    }

    @Override
    public ChunkStatus getChunkStatus() {
        return STATUS;
    }

    @Override
    public void generateGroup(ThreadWorldGenParams tParams, DhLitWorldGenRegion worldGenRegion, ArrayGridList<ChunkWrapper> chunkWrappers) {
        ArrayList<ChunkWrapper> chunksToDo = this.getChunkWrappersToGenerate(chunkWrappers);
        if (!this.environment.globalParams.worldOptions.m_247749_()) {
            return;
        }
        for (ChunkWrapper chunkWrapper : chunksToDo) {
            ChunkAccess chunk = chunkWrapper.getChunk();
            STRUCTURE_PLACEMENT_LOCK.lock();
            this.environment.globalParams.generator.m_255037_(this.environment.globalParams.registry, this.environment.globalParams.mcServerLevel.m_7726_().m_255415_(), (StructureManager)tParams.structFeatManager, chunk, this.environment.globalParams.structures);
            try {
                tParams.structCheck.m_197282_(chunk.m_7697_(), chunk.m_6633_());
            }
            catch (ArrayIndexOutOfBoundsException firstEx) {
                tParams.recreateStructureCheck();
                try {
                    tParams.structCheck.m_197282_(chunk.m_7697_(), chunk.m_6633_());
                }
                catch (ArrayIndexOutOfBoundsException secondEx) {
                    LOGGER.error("Unable to create structure starts for " + String.valueOf(chunk.m_7697_()) + ". This is an error with MC's world generation. Ignoring and continuing generation. Error: " + secondEx.getMessage(), new Object[0]);
                }
            }
            STRUCTURE_PLACEMENT_LOCK.unlock();
        }
    }
}

