/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.chunkFileHandling;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.util.ExceptionUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModChecker;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.chunkFileHandling.ChunkCompoundTagParser;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.RegionFileStorageExternalCache;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.params.GlobalWorldGenParams;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;

public class ChunkFileReader
implements AutoCloseable {
    public static final DhLogger LOGGER = new DhLoggerBuilder().name("LOD World Gen").fileLevelConfig(Config.Common.Logging.logWorldGenEventToFile).build();
    public static final DhLogger CHUNK_LOAD_LOGGER = new DhLoggerBuilder().name("LOD Chunk Loading").fileLevelConfig(Config.Common.Logging.logWorldGenChunkLoadEventToFile).build();
    private static final IModChecker MOD_CHECKER = SingletonInjector.INSTANCE.get(IModChecker.class);
    public final GlobalWorldGenParams params;
    private boolean pullExistingChunkUsingMcAsyncMethod = false;
    private final AtomicReference<RegionFileStorageExternalCache> regionFileStorageCacheRef = new AtomicReference();

    public RegionFileStorageExternalCache getOrCreateRegionFileCache(RegionFileStorage storage) {
        RegionFileStorageExternalCache cache = this.regionFileStorageCacheRef.get();
        if (cache == null && !this.regionFileStorageCacheRef.compareAndSet(null, cache = new RegionFileStorageExternalCache(storage))) {
            cache = this.regionFileStorageCacheRef.get();
        }
        return cache;
    }

    public ChunkFileReader(GlobalWorldGenParams params) {
        this.params = params;
        if (MOD_CHECKER.isModLoaded("c2me")) {
            LOGGER.info("C2ME detected: DH's pre-existing chunk accessing will use methods handled by C2ME.", new Object[0]);
            this.pullExistingChunkUsingMcAsyncMethod = true;
        }
    }

    public CompletableFuture<ChunkWrapper> createEmptyOrPreExistingChunkWrapperAsync(int chunkX, int chunkZ, Map<DhChunkPos, ChunkLightStorage> chunkSkyLightingByDhPos, Map<DhChunkPos, ChunkLightStorage> chunkBlockLightingByDhPos, Map<DhChunkPos, ChunkWrapper> generatedChunkWrapperByDhPos) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        DhChunkPos dhChunkPos = new DhChunkPos(chunkX, chunkZ);
        if (generatedChunkWrapperByDhPos.containsKey(dhChunkPos)) {
            return CompletableFuture.completedFuture(generatedChunkWrapperByDhPos.get(dhChunkPos));
        }
        return ((CompletableFuture)((CompletableFuture)this.getChunkNbtDataAsync(chunkPos).thenApply(chunkData -> {
            ChunkWrapper newChunkWrapper = this.loadOrMakeChunkWrapper(chunkPos, (CompoundTag)chunkData);
            ChunkCompoundTagParser.CombinedChunkLightStorage combinedLights = ChunkCompoundTagParser.readLight(newChunkWrapper.getChunk(), chunkData);
            if (combinedLights != null) {
                chunkSkyLightingByDhPos.put(dhChunkPos, combinedLights.skyLightStorage);
                chunkBlockLightingByDhPos.put(dhChunkPos, combinedLights.blockLightStorage);
            }
            return newChunkWrapper;
        })).handle((newChunkWrapper, throwable) -> {
            if (newChunkWrapper != null) {
                return newChunkWrapper;
            }
            return this.CreateProtoChunkWrapper(this.params.mcServerLevel, chunkPos);
        })).thenApply(newChunkWrapper -> {
            generatedChunkWrapperByDhPos.put(dhChunkPos, (ChunkWrapper)newChunkWrapper);
            return newChunkWrapper;
        });
    }

    private CompletableFuture<CompoundTag> getChunkNbtDataAsync(ChunkPos chunkPos) {
        ServerLevel level = this.params.mcServerLevel;
        try {
            IOWorker ioWorker = level.m_7726_().f_8325_.f_63495_;
            if (!this.pullExistingChunkUsingMcAsyncMethod && ioWorker.f_63518_ != null) {
                try {
                    RegionFileStorage storage = this.params.mcServerLevel.m_7726_().f_8325_.f_63495_.f_63518_;
                    RegionFileStorageExternalCache cache = this.getOrCreateRegionFileCache(storage);
                    return CompletableFuture.completedFuture(cache.read(chunkPos));
                }
                catch (NullPointerException e) {
                    LOGGER.error("Unexpected issue pulling pre-existing chunk [" + String.valueOf(chunkPos) + "], falling back to async chunk pulling. This may cause server-tick lag.", e);
                    this.pullExistingChunkUsingMcAsyncMethod = true;
                    return this.getChunkNbtDataAsync(chunkPos);
                }
            }
            if (!this.pullExistingChunkUsingMcAsyncMethod) {
                LOGGER.info("Unable to pull pre-existing chunk using synchronous method. Falling back to async method. this may cause server-tick lag.", new Object[0]);
                this.pullExistingChunkUsingMcAsyncMethod = true;
            }
            return ((CompletableFuture)ioWorker.m_156587_(chunkPos).thenApply(optional -> optional.orElse(null))).exceptionally(throwable -> {
                Throwable actualThrowable = throwable;
                while (actualThrowable instanceof CompletionException) {
                    CompletionException completionException = (CompletionException)actualThrowable;
                    actualThrowable = completionException.getCause();
                }
                boolean isShutdownException = ExceptionUtil.isShutdownException(actualThrowable);
                if (!isShutdownException) {
                    CHUNK_LOAD_LOGGER.warn("DistantHorizons: Couldn't load or make chunk [" + String.valueOf(chunkPos) + "], error: [" + actualThrowable.getMessage() + "].", actualThrowable);
                }
                return null;
            });
        }
        catch (ClosedByInterruptException ignore) {
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            CHUNK_LOAD_LOGGER.warn("Couldn't load or make chunk [" + String.valueOf(chunkPos) + "]. Error: [" + e.getMessage() + "].", e);
            return CompletableFuture.completedFuture(null);
        }
    }

    private ChunkWrapper loadOrMakeChunkWrapper(ChunkPos chunkPos, CompoundTag chunkTagData) {
        ServerLevel mcServerLevel = this.params.mcServerLevel;
        if (chunkTagData == null) {
            return this.CreateProtoChunkWrapper(mcServerLevel, chunkPos);
        }
        try {
            ChunkWrapper chunkWrapper = ChunkCompoundTagParser.createFromTag((WorldGenLevel)mcServerLevel, this.params.dhServerLevel, chunkPos, chunkTagData);
            if (chunkWrapper == null) {
                chunkWrapper = this.CreateProtoChunkWrapper(mcServerLevel, chunkPos);
            }
            return chunkWrapper;
        }
        catch (Exception e) {
            CHUNK_LOAD_LOGGER.error("DistantHorizons: couldn't load or make chunk at [" + String.valueOf(chunkPos) + "].Please try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen.\nError: [" + e.getMessage() + "].", e);
            return this.CreateProtoChunkWrapper(mcServerLevel, chunkPos);
        }
    }

    public ChunkWrapper CreateProtoChunkWrapper(ServerLevel level, ChunkPos chunkPos) {
        ProtoChunk chunk = ChunkFileReader.CreateProtoChunk(level, chunkPos);
        return new ChunkWrapper((ChunkAccess)chunk, this.params.dhServerLevel.getLevelWrapper(), false);
    }

    public static ProtoChunk CreateProtoChunk(ServerLevel level, ChunkPos chunkPos) {
        return new ProtoChunk(chunkPos, UpgradeData.f_63320_, (LevelHeightAccessor)level, level.m_9598_().m_175515_(Registries.f_256952_), null);
    }

    @Override
    public void close() {
        RegionFileStorageExternalCache regionStorage = this.regionFileStorageCacheRef.get();
        if (regionStorage != null) {
            try {
                regionStorage.close();
            }
            catch (ClosedChannelException closedChannelException) {
            }
            catch (IOException e) {
                LOGGER.error("Failed to close region file storage cache, error: [" + e.getMessage() + "].", e);
            }
        }
    }
}

