/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.model;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import me.pepperbell.continuity.api.client.CachingPredicates;
import me.pepperbell.continuity.api.client.QuadProcessor;
import net.minecraft.class_1058;
import net.minecraft.class_2680;
import org.jetbrains.annotations.ApiStatus;

public final class QuadProcessors {
    private static ProcessorHolder[] processorHolders = new ProcessorHolder[0];
    private static final BlockStateKeyCache CACHE = new BlockStateKeyCache();

    public static Function<class_1058, Slice> getCache(class_2680 state) {
        return CACHE.apply(state);
    }

    private static Slice computeSlice(class_2680 state, class_1058 sprite) {
        ObjectArrayList processorList = new ObjectArrayList();
        ObjectArrayList multipassProcessorList = new ObjectArrayList();
        for (ProcessorHolder holder : processorHolders) {
            QuadProcessor processor = holder.processor();
            CachingPredicates predicates = holder.predicates();
            if (predicates.affectsBlockStates() && !predicates.affectsBlockState(state)) continue;
            if (predicates.affectsSprites()) {
                if (!predicates.affectsSprite(sprite)) continue;
                processorList.add(processor);
                if (!predicates.isValidForMultipass()) continue;
                multipassProcessorList.add(processor);
                continue;
            }
            processorList.add(processor);
        }
        QuadProcessor[] processors = (QuadProcessor[])processorList.toArray(QuadProcessor[]::new);
        QuadProcessor[] multipassProcessors = (QuadProcessor[])multipassProcessorList.toArray(QuadProcessor[]::new);
        return new Slice(processors, multipassProcessors);
    }

    @ApiStatus.Internal
    public static void reload(List<ProcessorHolder> processorHolders) {
        QuadProcessors.processorHolders = (ProcessorHolder[])processorHolders.toArray(ProcessorHolder[]::new);
        CACHE.clear();
    }

    private static class BlockStateKeyCache {
        private final Reference2ReferenceOpenHashMap<class_2680, SpriteKeyCache> map = new Reference2ReferenceOpenHashMap();
        private final StampedLock lock = new StampedLock();

        private BlockStateKeyCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpriteKeyCache apply(class_2680 state) {
            SpriteKeyCache innerCache;
            long optimisticReadStamp = this.lock.tryOptimisticRead();
            if (optimisticReadStamp != 0L) {
                try {
                    innerCache = (SpriteKeyCache)this.map.get((Object)state);
                    if (innerCache != null && this.lock.validate(optimisticReadStamp)) {
                        return innerCache;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long readStamp = this.lock.readLock();
            try {
                innerCache = (SpriteKeyCache)this.map.get((Object)state);
            }
            finally {
                this.lock.unlockRead(readStamp);
            }
            if (innerCache == null) {
                long writeStamp = this.lock.writeLock();
                try {
                    innerCache = (SpriteKeyCache)this.map.get((Object)state);
                    if (innerCache == null) {
                        innerCache = new SpriteKeyCache(state);
                        this.map.put((Object)state, (Object)innerCache);
                    }
                }
                finally {
                    this.lock.unlockWrite(writeStamp);
                }
            }
            return innerCache;
        }

        public void clear() {
            long writeStamp = this.lock.writeLock();
            try {
                this.map.values().forEach(SpriteKeyCache::clear);
            }
            finally {
                this.lock.unlockWrite(writeStamp);
            }
        }
    }

    private static class SpriteKeyCache
    implements Function<class_1058, Slice> {
        private final Reference2ReferenceOpenHashMap<class_1058, Slice> map = new Reference2ReferenceOpenHashMap(4, 0.5f);
        private final StampedLock lock = new StampedLock();
        private final class_2680 state;

        public SpriteKeyCache(class_2680 state) {
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Slice apply(class_1058 sprite) {
            Slice slice;
            long optimisticReadStamp = this.lock.tryOptimisticRead();
            if (optimisticReadStamp != 0L) {
                try {
                    slice = (Slice)this.map.get((Object)sprite);
                    if (slice != null && this.lock.validate(optimisticReadStamp)) {
                        return slice;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long readStamp = this.lock.readLock();
            try {
                slice = (Slice)this.map.get((Object)sprite);
            }
            finally {
                this.lock.unlockRead(readStamp);
            }
            if (slice == null) {
                long writeStamp = this.lock.writeLock();
                try {
                    slice = (Slice)this.map.get((Object)sprite);
                    if (slice == null) {
                        slice = QuadProcessors.computeSlice(this.state, sprite);
                        this.map.put((Object)sprite, (Object)slice);
                    }
                }
                finally {
                    this.lock.unlockWrite(writeStamp);
                }
            }
            return slice;
        }

        public void clear() {
            long writeStamp = this.lock.writeLock();
            try {
                this.map.clear();
            }
            finally {
                this.lock.unlockWrite(writeStamp);
            }
        }
    }

    public record ProcessorHolder(QuadProcessor processor, CachingPredicates predicates) {
    }

    public record Slice(QuadProcessor[] processors, QuadProcessor[] multipassProcessors) {
    }
}

