/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.defaults.mixin.common;

import com.mojang.datafixers.util.Either;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import shcm.shsupercm.fabric.citresewn.cit.CITType;
import shcm.shsupercm.fabric.citresewn.defaults.common.ResewnItemModelIdentifier;
import shcm.shsupercm.fabric.citresewn.defaults.mixin.types.item.JsonUnbakedModelAccessor;

@Mixin(value={ModelBakery.class})
public class ModelLoaderMixin {
    @Inject(method={"loadModelFromJson"}, cancellable=true, at={@At(value="HEAD")})
    public void citresewn$forceLiteralResewnModelIdentifier(ResourceLocation originalId, CallbackInfoReturnable<BlockModel> cir) {
        if (ResewnItemModelIdentifier.marked(originalId)) {
            ResourceLocation id = ResewnItemModelIdentifier.unpack(originalId);
            try (InputStream is = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(id).orElseThrow()).m_215507_();){
                BlockModel json = BlockModel.m_111463_((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                json.f_111416_ = id.toString();
                json.f_111416_ = json.f_111416_.substring(0, json.f_111416_.length() - 5);
                ((JsonUnbakedModelAccessor)json).getTextureMap().replaceAll((layer, original) -> {
                    Optional left = original.left();
                    if (left.isPresent()) {
                        ResourceLocation resolvedIdentifier;
                        String originalPath = ((Material)left.get()).m_119203_().m_135815_();
                        String[] split = originalPath.split("/");
                        if ((originalPath.startsWith("./") || split.length > 2 && split[1].equals("cit")) && (resolvedIdentifier = CITType.resolveAsset((ResourceLocation)id, (String)originalPath, (String)"textures", (String)".png", (ResourceManager)Minecraft.m_91087_().m_91098_())) != null) {
                            return Either.left((Object)new Material(((Material)left.get()).m_119193_(), resolvedIdentifier));
                        }
                    }
                    return original;
                });
                ResourceLocation parentId = ((JsonUnbakedModelAccessor)json).getParentId();
                if (parentId != null) {
                    String[] parentIdPathSplit = parentId.m_135815_().split("/");
                    if ((parentId.m_135815_().startsWith("./") || parentIdPathSplit.length > 2 && parentIdPathSplit[1].equals("cit")) && (parentId = CITType.resolveAsset((ResourceLocation)id, (String)parentId.m_135815_(), (String)"models", (String)".json", (ResourceManager)Minecraft.m_91087_().m_91098_())) != null) {
                        ((JsonUnbakedModelAccessor)json).setParentId(ResewnItemModelIdentifier.pack(parentId));
                    }
                }
                json.m_111484_().replaceAll(override -> {
                    ResourceLocation resolvedOverridePath;
                    String[] modelIdPathSplit = override.m_111718_().m_135815_().split("/");
                    if ((override.m_111718_().m_135815_().startsWith("./") || modelIdPathSplit.length > 2 && modelIdPathSplit[1].equals("cit")) && (resolvedOverridePath = CITType.resolveAsset((ResourceLocation)id, (String)override.m_111718_().m_135815_(), (String)"models", (String)".json", (ResourceManager)Minecraft.m_91087_().m_91098_())) != null) {
                        return new ItemOverride(ResewnItemModelIdentifier.pack(resolvedOverridePath), override.m_173449_().collect(Collectors.toList()));
                    }
                    return override;
                });
                cir.setReturnValue((Object)json);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

