/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.effects;

import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.UUID;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MoltenThornEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation SPAWN = RawAnimation.begin().thenPlay("SPAWN");
    private final RawAnimation DESPAWN = RawAnimation.begin().thenPlay("DESPAWN");
    private int warmupDelayTicks;
    private int lifeTicks;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;
    private static final EntityDataAccessor<Boolean> ACTIVATE = SynchedEntityData.m_135353_(MoltenThornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(MoltenThornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(MoltenThornEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public float activateProgress;
    public float prevactivateProgress;

    public MoltenThornEntity(EntityType<? extends MoltenThornEntity> entity, Level level) {
        super(entity, level);
    }

    public MoltenThornEntity(Level worldIn, double x, double y, double z, float yRot, int delay, float damage, LivingEntity casterIn) {
        this((EntityType<? extends MoltenThornEntity>)((EntityType)MLEntities.INFERNAL_THORNS.get()), worldIn);
        this.warmupDelayTicks = delay;
        this.setCaster(casterIn);
        this.setDamage(damage);
        this.m_146922_(yRot * 57.295776f);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ACTIVATE, (Object)false);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LIFESPAN, (Object)62);
    }

    public int getLifeTicks() {
        return (Integer)this.f_19804_.m_135370_(LIFESPAN);
    }

    public void setLifeTicks(int pTicks) {
        this.f_19804_.m_135381_(LIFESPAN, (Object)pTicks);
        this.lifeTicks = pTicks;
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public void setCaster(@Nullable LivingEntity owner) {
        this.caster = owner;
        this.casterUuid = owner == null ? null : owner.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void m_7378_(CompoundTag compound) {
        this.warmupDelayTicks = compound.m_128451_("Warmup");
        this.setLifeTicks(compound.m_128451_("LifeSpan"));
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
        this.setDamage(compound.m_128457_("damage"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Warmup", this.warmupDelayTicks);
        compound.m_128405_("LifeSpan", this.lifeTicks);
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
        compound.m_128350_("damage", this.getDamage());
    }

    public void m_8119_() {
        this.prevactivateProgress = this.activateProgress;
        if (this.m_9236_().f_46443_) {
            if (!this.isActivate() && this.activateProgress < 10.0f) {
                this.activateProgress += 1.0f;
            }
            if (this.getLifeTicks() == 10 || this.getLifeTicks() == 60) {
                this.spawnGroundParticles();
            }
            if (this.getLifeTicks() == 49) {
                this.spawnActivationParticles();
            }
        } else if (this.warmupDelayTicks >= 0) {
            --this.warmupDelayTicks;
            if (this.warmupDelayTicks < 0) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
            }
        } else {
            if (this.getLifeTicks() >= 0) {
                this.setLifeTicks(this.getLifeTicks() - 1);
            }
            if (this.getLifeTicks() % 5 == 0) {
                this.applyDamageToEntities();
            }
            if (this.getLifeTicks() < 0) {
                this.m_146870_();
            }
        }
        super.m_8119_();
    }

    public boolean isActivate() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVATE);
    }

    public void setActivate(boolean Activate) {
        this.f_19804_.m_135381_(ACTIVATE, (Object)Activate);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 4) {
            this.triggerAnim("controller", "spawn");
            this.clientSideAttackStarted = true;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)MLSounds.RUPTURE_BURST.get(), this.m_5720_(), 0.5f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
            }
        }
    }

    private void applyDamageToEntities() {
        for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.3).m_82323_(this.m_20191_()))) {
            if (!livingentity.m_6084_() || livingentity.m_20147_() || livingentity == this.getCaster()) continue;
            livingentity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingentity), this.getDamage());
        }
    }

    private void spawnGroundParticles() {
        for (int i = 0; i < 80; ++i) {
            BlockState block = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
            double d1 = this.m_20186_() + 0.03;
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), d0, d1, d2, this.f_19796_.m_188583_() * 0.07, this.f_19796_.m_188583_() * 0.07, this.f_19796_.m_188583_() * 0.07);
        }
        this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)MLSounds.RUPTURE_BURST.get(), this.m_5720_(), 0.5f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
    }

    private void spawnActivationParticles() {
        for (int i = 0; i < 12; ++i) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
            double d1 = this.m_20186_() + 0.05 + this.f_19796_.m_188500_();
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123784_, d0, d1, d2, (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3, 0.3 + this.f_19796_.m_188500_() * 0.3, (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3);
        }
    }

    public float m_213856_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", state -> {
            if (this.getLifeTicks() <= 10) {
                return state.setAndContinue(this.DESPAWN);
            }
            if (this.getLifeTicks() >= 11 && this.getLifeTicks() <= 52) {
                return state.setAndContinue(this.IDLE);
            }
            return PlayState.STOP;
        }).triggerableAnim("spawn", this.SPAWN)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

