/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.inquisitor;

import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.PossessedArmorEntity;
import com.ovinter.mythsandlegends.entity.PossessedArmorInquisitorEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ServerLevelAccessor;

public class SummonMinionsGoal<T extends MLEntity>
extends Goal {
    private final PossessedArmorInquisitorEntity mob;
    private LivingEntity target;
    private Class<T> entity;
    private int minionCount;
    private int currentWave;
    private int waves;
    private int baseWaveDelay;
    private int waveDelay = 40;

    public SummonMinionsGoal(PossessedArmorInquisitorEntity pMob, int pMinionCount, int pWaves, int pWaveDelay, Class<T> pEntity) {
        this.mob = pMob;
        this.minionCount = pMinionCount;
        this.waves = pWaves;
        this.baseWaveDelay = pWaveDelay;
        this.entity = pEntity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        this.target = this.mob.m_5448_();
        return this.target != null && this.target.m_6084_() && this.mob.m_20096_() && !this.mob.m_21224_() && !this.mob.isStunned() && this.mob.summonCooldown == 0 && this.mob.getHasHalfHealth();
    }

    public boolean m_8045_() {
        return this.target != null && this.target.m_6084_() && this.mob.m_6084_();
    }

    public void m_8056_() {
        this.mob.setAnimationId(this.mob.SUMMON);
        this.mob.m_21573_().m_26573_();
        this.currentWave = 0;
    }

    public void m_8041_() {
        this.target = null;
        this.mob.setAnimationId(0);
        this.mob.m_21573_().m_26569_();
        this.mob.summonCooldown = this.mob.SUMMON_COOLDOWN;
        this.currentWave = 0;
    }

    public void m_8037_() {
        if (this.target == null) {
            return;
        }
        this.mob.m_21563_().m_148051_((Entity)this.target);
        this.mob.m_21563_().m_8128_();
        --this.waveDelay;
        if (this.currentWave < this.waves) {
            if (this.waveDelay <= 0) {
                this.mob.playSummonSound();
                this.summonMinion();
                this.waveDelay = this.baseWaveDelay;
                ++this.currentWave;
            }
        } else if (this.currentWave == this.waves && this.waveDelay <= 0) {
            this.m_8041_();
        }
    }

    public boolean m_183429_() {
        return true;
    }

    void summonMinion() {
        if (this.entity == PossessedArmorEntity.class) {
            for (int i = 0; i < this.minionCount; ++i) {
                PossessedArmorEntity minion = new PossessedArmorEntity((EntityType<? extends Monster>)((EntityType)MLEntities.POSSESSED_ARMOR.get()), this.mob.m_9236_());
                minion.m_6518_((ServerLevelAccessor)this.mob.m_9236_(), this.mob.m_9236_().m_6436_(this.mob.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                double offsetX = (this.mob.m_217043_().m_188500_() - 0.5) * 5.0;
                double offsetZ = (this.mob.m_217043_().m_188500_() - 0.5) * 5.0;
                minion.m_6034_(this.mob.m_20185_() + offsetX, this.mob.m_20186_(), this.mob.m_20189_() + offsetZ);
                this.mob.m_9236_().m_7967_((Entity)minion);
            }
        }
    }
}

