/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.gargoyle;

import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.GargoyleEntity;
import com.ovinter.mythsandlegends.entity.projectile.MoltenRockEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ShootMoltenBallGoal
extends Goal {
    private final GargoyleEntity mob;
    private LivingEntity target;
    private int attackTick;
    private int ATTACK_DURATION = 25;

    public ShootMoltenBallGoal(GargoyleEntity pMob) {
        this.mob = pMob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        this.target = this.mob.m_5448_();
        return this.target != null && this.mob.getAnimationId() == 0 && this.target.m_6084_() && this.mob.rangedCooldown == 0 && this.mob.getVariant() == 1 && this.mob.m_20270_((Entity)this.target) < 20.0f;
    }

    public boolean m_8045_() {
        return this.target != null && this.target.m_6084_() && this.mob.rangedCooldown == 0;
    }

    public void m_8056_() {
        this.mob.setAnimationId(2);
        this.attackTick = 0;
    }

    public void m_8041_() {
        this.mob.setAnimationId(0);
        this.mob.rangedCooldown = DefaultMobAttributes.GARGOYLE_ABILITY_COOLDOWN;
        this.attackTick = 0;
        this.target = null;
    }

    public void m_8037_() {
        ++this.attackTick;
        if (this.target == null || !this.target.m_6084_()) {
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (this.attackTick == 15) {
            this.performRangedAttack();
        }
        if (this.attackTick == this.ATTACK_DURATION) {
            this.m_8041_();
        }
    }

    public boolean m_183429_() {
        return true;
    }

    private void performRangedAttack() {
        Level level = this.mob.m_9236_();
        Vec3 targetPos = this.target.m_20182_();
        int projectiles = 8;
        for (int i = 0; i < projectiles; ++i) {
            MoltenRockEntity projectile = new MoltenRockEntity((EntityType<? extends ThrowableProjectile>)((EntityType)MLEntities.MOLTEN_ROCK.get()), level, (LivingEntity)this.mob);
            projectile.m_6034_(this.mob.m_20185_(), this.mob.m_20188_() + 0.3, this.mob.m_20189_());
            double targetX = targetPos.f_82479_ + (i == 0 ? 0.0 : this.mob.m_217043_().m_216328_(0.0, 4.0));
            double targetY = targetPos.f_82480_ + this.mob.m_217043_().m_216328_(0.0, 2.0);
            double targetZ = targetPos.f_82481_ + (i == 0 ? 0.0 : this.mob.m_217043_().m_216328_(0.0, 4.0));
            Vec3 dir = new Vec3(targetX - this.mob.m_20185_(), targetY - this.mob.m_20188_() + 0.3, targetZ - this.mob.m_20189_()).m_82541_();
            float velocity = 0.8f + this.mob.m_217043_().m_188501_() * 0.2f;
            projectile.m_6686_(dir.f_82479_, dir.f_82480_ + 0.1, dir.f_82481_, velocity, 4.0f);
            level.m_7967_((Entity)projectile);
            this.mob.m_5496_((SoundEvent)MLSounds.IMP_SHOOT.get(), 1.0f, 1.0f + this.mob.m_217043_().m_188501_() * 0.3f);
        }
    }
}

