/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ScorchedSentinelEntity
extends MLEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    private final RawAnimation RUN = RawAnimation.begin().thenLoop("RUN");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private final RawAnimation TAIL = RawAnimation.begin().thenLoop("TAIL");
    private final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");

    public ScorchedSentinelEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, DefaultMobAttributes.SCORCHED_HEALTH).m_22268_(Attributes.f_22281_, DefaultMobAttributes.SCORCHED_DAMAGE).m_22268_(Attributes.f_22279_, DefaultMobAttributes.SCORCHED_MOVEMENT).m_22268_(Attributes.f_22277_, DefaultMobAttributes.SCORCHED_FOLLOW_RANGE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new AnimatedMeleeAttackGoal(this, 20, 8, 3.0f));
        this.f_21345_.m_25352_(3, (Goal)new ChaseTargetGoal(this, false, 1.6));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 12.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    protected void m_8024_() {
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.m_8024_();
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 25 && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_7327_(Entity pEntity) {
        boolean success = super.m_7327_(pEntity);
        if (success) {
            this.playAttackSound();
        }
        return success;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setConfigAttributes();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_7307_(Entity entity) {
        if (entity == this) {
            return true;
        }
        if (entity.getClass() == this.getClass()) {
            return true;
        }
        return super.m_7307_(entity);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)MLSounds.SCORCHED_SENTINEL_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)MLSounds.SCORCHED_SENTINEL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MLSounds.SCORCHED_SENTINEL_DEATH.get();
    }

    void playAttackSound() {
        this.m_216990_((SoundEvent)MLSounds.SCORCHED_SENTINEL_ATTACK.get());
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return state.setAndContinue(this.DEATH);
        }
        if (state.isMoving() && this.isRunning()) {
            return state.setAndContinue(this.RUN);
        }
        return state.isMoving() ? state.setAndContinue(this.WALK) : state.setAndContinue(this.IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return PlayState.STOP;
        }
        if (this.getAnimationId() == 1 && this.getAttackTicks() == 19 && this.m_6084_()) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(this.ATTACK);
        }
        return PlayState.CONTINUE;
    }

    PlayState tailPredicate(AnimationState<?> state) {
        return this.m_21224_() ? PlayState.STOP : state.setAndContinue(this.TAIL);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate).setSoundKeyframeHandler(state -> {
            if (state.getKeyframeData().getSound().equals("step") && this.m_20096_()) {
                this.m_9236_().m_245747_(this.m_20097_(), SoundEvents.f_11727_, SoundSource.HOSTILE, 1.0f, 0.7f, false);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 2, this::attackPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "tailController", 0, this::tailPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.SCORCHED_SENTINEL_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.SCORCHED_SENTINEL_DAMAGE.get()).doubleValue());
        this.m_21153_((float)((Double)Config.SCORCHED_SENTINEL_HEALTH.get()).doubleValue());
    }
}

