/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.entity.WarbornAegisEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLParticles;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IgnisNexusEntity
extends Entity
implements GeoEntity {
    AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private static final EntityDataAccessor<Optional<UUID>> BOSS_UUID = SynchedEntityData.m_135353_(IgnisNexusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public IgnisNexusEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19850_ = true;
    }

    public IgnisNexusEntity(Level level, UUID bossUUID) {
        this((EntityType)MLEntities.IGNIS_NEXUS.get(), level);
        this.f_19804_.m_135381_(BOSS_UUID, Optional.of(bossUUID));
    }

    PlayState predicate(AnimationState<?> state) {
        return state.setAndContinue(this.IDLE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BOSS_UUID, Optional.empty());
    }

    public void onRemovedFromWorld() {
        Entity boss;
        Optional bossUUID;
        super.onRemovedFromWorld();
        if (!this.m_9236_().f_46443_ && (bossUUID = (Optional)this.f_19804_.m_135370_(BOSS_UUID)).isPresent() && (boss = ((ServerLevel)this.m_9236_()).m_8791_((UUID)bossUUID.get())) instanceof WarbornAegisEntity) {
            ((WarbornAegisEntity)boss).onNexusDestroyed(this.m_20148_());
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (pSource.m_7639_() instanceof WarbornAegisEntity) {
            return false;
        }
        if (!this.m_213877_() && !this.m_9236_().f_46443_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.destroyNexus();
        }
        return true;
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128403_("BossUUID")) {
            this.f_19804_.m_135381_(BOSS_UUID, Optional.of(pCompound.m_128342_("BossUUID")));
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        if (((Optional)this.f_19804_.m_135370_(BOSS_UUID)).isPresent()) {
            pCompound.m_128362_("BossUUID", (UUID)((Optional)this.f_19804_.m_135370_(BOSS_UUID)).get());
        }
    }

    public void m_8119_() {
        LivingEntity boss;
        super.m_8119_();
        if (this.f_19797_ % 5 == 0) {
            this.spawnSphereParticles((ParticleOptions)MLParticles.LAMPAD_BOOST_PARTICLE.get(), 1.5, 8);
        }
        if (this.m_9236_().f_46443_ && (boss = this.getBoss()) != null && boss.m_6084_()) {
            this.createBeamEffects(boss);
        }
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6673_(DamageSource pSource) {
        return false;
    }

    public LivingEntity getBoss() {
        Optional bossUUID = (Optional)this.m_20088_().m_135370_(BOSS_UUID);
        if (bossUUID.isPresent()) {
            if (!this.m_9236_().f_46443_) {
                Entity entity = ((ServerLevel)this.m_9236_()).m_8791_((UUID)bossUUID.get());
                return entity instanceof LivingEntity ? (LivingEntity)entity : null;
            }
            AABB searchArea = new AABB(this.m_20183_()).m_82400_(32.0);
            for (LivingEntity entity : this.m_9236_().m_6443_(LivingEntity.class, searchArea, e -> true)) {
                if (!entity.m_20148_().equals(bossUUID.get())) continue;
                return entity;
            }
        }
        return null;
    }

    private void destroyNexus() {
        this.m_5496_((SoundEvent)MLSounds.IGNIS_NEXUS_DESTROYED.get(), 2.5f, 1.0f);
        this.spawnDestroyParticles();
    }

    private void createBeamEffects(LivingEntity boss) {
        Vec3 startPos = this.m_20182_().m_82520_(0.0, 1.5, 0.0);
        Vec3 endPos = boss.m_20182_().m_82520_(0.0, (double)(boss.m_20206_() / 2.0f), 0.0);
        double distance = startPos.m_82554_(endPos);
        int particles = (int)(distance * 1.2);
        for (int i = 0; i <= particles; ++i) {
            double progress = (double)i / (double)particles;
            double x = Mth.m_14139_((double)progress, (double)startPos.f_82479_, (double)endPos.f_82479_);
            double y = Mth.m_14139_((double)progress, (double)startPos.f_82480_, (double)endPos.f_82480_);
            double z = Mth.m_14139_((double)progress, (double)startPos.f_82481_, (double)endPos.f_82481_);
            SimpleParticleType mainParticle = this.f_19797_ % 4 == 0 ? ParticleTypes.f_123744_ : (ParticleOptions)MLParticles.LAMPAD_BOOST_PARTICLE.get();
            this.m_9236_().m_7106_((ParticleOptions)mainParticle, x += (this.f_19796_.m_188500_() - 0.5) * 0.2, y += (this.f_19796_.m_188500_() - 0.5) * 0.2, z += (this.f_19796_.m_188500_() - 0.5) * 0.2, (this.f_19796_.m_188500_() - 0.5) * 0.1, 0.05, (this.f_19796_.m_188500_() - 0.5) * 0.1);
        }
    }

    private void spawnSphereParticles(ParticleOptions particle, double radius, int count) {
        double centerY = this.m_20186_() + (double)(this.m_20206_() / 2.0f);
        for (int i = 0; i < count; ++i) {
            double theta = this.f_19796_.m_188500_() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * this.f_19796_.m_188500_() - 1.0);
            double xOffset = radius * Math.sin(phi) * Math.cos(theta);
            double yOffset = radius * Math.sin(phi) * Math.sin(theta);
            double zOffset = radius * Math.cos(phi);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + xOffset, centerY + yOffset, this.m_20189_() + zOffset, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_(particle, this.m_20185_() + xOffset, centerY + yOffset, this.m_20189_() + zOffset, 0.0, 0.0, 0.0);
        }
    }

    private void spawnDestroyParticles() {
        for (int i = 0; i < 10; ++i) {
            double xOffset = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double yOffset = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double zOffset = (this.f_19796_.m_188500_() - 0.5) * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + xOffset, this.m_20186_() + yOffset, this.m_20189_() + zOffset, 0.0, 0.1, 0.0);
        }
    }
}

