/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.client.gui.screen;

import com.ovinter.mythsandlegends.registry.MLBlocks;
import com.ovinter.mythsandlegends.registry.MLItems;
import com.ovinter.mythsandlegends.registry.MLMenus;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class StoneSanctumMenu
extends AbstractContainerMenu {
    private static final int HOT_BAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int RESULT_SLOT = 6;
    private static final int SLOT_COUNT = 7;
    private Player player;
    private final ContainerLevelAccess access;
    private final Container container = new SimpleContainer(7){

        public void m_6596_() {
            StoneSanctumMenu.this.m_6199_((Container)this);
            super.m_6596_();
        }
    };
    private final ResultContainer resultContainer = new ResultContainer(){

        public void m_6596_() {
            StoneSanctumMenu.this.m_6199_((Container)this);
            super.m_6596_();
        }
    };

    public StoneSanctumMenu(int containerId, Inventory inventory, ContainerLevelAccess pAccess) {
        super((MenuType)MLMenus.STONE_SANCTUM_TABLE.get(), containerId);
        this.access = pAccess;
        this.player = inventory.f_35978_;
        this.addSlots(this.container);
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
    }

    @NotNull
    public ItemStack m_7648_(Player player, int quickMovedSlotIndex) {
        ItemStack quickMovedStack = ItemStack.f_41583_;
        Slot quickMovedSlot = (Slot)this.f_38839_.get(quickMovedSlotIndex);
        if (quickMovedSlot != null && quickMovedSlot.m_6657_()) {
            ItemStack rawStack = quickMovedSlot.m_7993_();
            quickMovedStack = rawStack.m_41777_();
            if (quickMovedSlotIndex == 6) {
                if (!this.m_38903_(rawStack, 7, 43, true)) {
                    return ItemStack.f_41583_;
                }
                quickMovedSlot.m_40234_(rawStack, quickMovedStack);
            } else if (quickMovedSlotIndex >= 7 && quickMovedSlotIndex < 43) {
                if (StoneSanctumFuelSlot.mayPlaceItem(quickMovedStack) && this.m_38903_(rawStack, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(rawStack, 0, 6, false) && (quickMovedSlotIndex < 34 ? !this.m_38903_(rawStack, 35, 43, false) : !this.m_38903_(rawStack, 7, 34, false))) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(rawStack, 7, 43, false)) {
                return ItemStack.f_41583_;
            }
            if (rawStack.m_41619_()) {
                quickMovedSlot.m_269060_(ItemStack.f_41583_);
            } else {
                quickMovedSlot.m_6654_();
            }
            if (rawStack.m_41613_() == quickMovedStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            quickMovedSlot.m_142406_(player, rawStack);
        }
        return quickMovedStack;
    }

    public void m_6199_(Container container) {
        boolean allFilled = true;
        for (int i = 0; i <= 5; ++i) {
            ItemStack stack = this.container.m_8020_(i);
            if (!stack.m_41619_()) continue;
            allFilled = false;
            break;
        }
        if (!allFilled) {
            this.resultContainer.m_8016_(6);
            return;
        }
        this.resultContainer.m_6836_(6, ((Item)MLItems.GARGOYLE_EFFIGY.get()).m_7968_());
    }

    public boolean m_6875_(Player player) {
        return StoneSanctumMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)MLBlocks.STONE_SANCTUM_TABLE.get()));
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(6);
        this.access.m_39292_((level, pos) -> this.m_150411_(player, this.container));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    private void addSlots(Container container) {
        this.m_38897_(new StoneSanctumFuelSlot(container, 0, 51, 15));
        this.m_38897_(new StoneSanctumIngredientSlot(container, 1, 23, 29));
        this.m_38897_(new StoneSanctumIngredientSlot(container, 2, 79, 29));
        this.m_38897_(new StoneSanctumIngredientSlot(container, 3, 28, 49));
        this.m_38897_(new StoneSanctumIngredientSlot(container, 4, 51, 56));
        this.m_38897_(new StoneSanctumIngredientSlot(container, 5, 74, 49));
        this.m_38897_(new StoneSanctumResultSlot((Container)this.resultContainer, 6, 143, 39));
    }

    static class StoneSanctumFuelSlot
    extends Slot {
        public StoneSanctumFuelSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return StoneSanctumFuelSlot.mayPlaceItem(stack);
        }

        private static boolean mayPlaceItem(ItemStack itemStack) {
            return itemStack.m_150930_((Item)MLItems.CURSED_CORE.get());
        }
    }

    static class StoneSanctumIngredientSlot
    extends Slot {
        public StoneSanctumIngredientSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return this.mayPlaceItem(stack);
        }

        private boolean mayPlaceItem(ItemStack stack) {
            return stack.m_150930_((Item)MLItems.GARGOYLE_HEAD.get()) || stack.m_150930_((Item)MLItems.GARGOYLE_TORSO.get()) || stack.m_150930_((Item)MLItems.GARGOYLE_ARM.get()) || stack.m_150930_((Item)MLItems.GARGOYLE_LEG.get()) || stack.m_150930_((Item)MLItems.GARGOYLE_WING.get());
        }
    }

    class StoneSanctumResultSlot
    extends Slot {
        public StoneSanctumResultSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public void m_142406_(Player player, ItemStack stack) {
            ((Slot)StoneSanctumMenu.this.f_38839_.get(0)).m_6201_(1);
            ((Slot)StoneSanctumMenu.this.f_38839_.get(1)).m_6201_(1);
            ((Slot)StoneSanctumMenu.this.f_38839_.get(2)).m_6201_(1);
            ((Slot)StoneSanctumMenu.this.f_38839_.get(3)).m_6201_(1);
            ((Slot)StoneSanctumMenu.this.f_38839_.get(4)).m_6201_(1);
            ((Slot)StoneSanctumMenu.this.f_38839_.get(5)).m_6201_(1);
            player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)MLSounds.STONE_SANCTUM.get(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
            super.m_142406_(player, stack);
        }
    }
}

