/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.api.util;

import com.ovinter.mythsandlegends.registry.MLParticles;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class ParticleGeneratorHelper {
    private static double rotationAngle = 0.0;

    public static void generateEntitySpawnFromGroundParticles(Level pLevel, LivingEntity pEntity) {
        int particleCount = 30;
        BlockState blockState = pEntity.m_20075_();
        if (blockState.m_60799_() != RenderShape.INVISIBLE) {
            for (int i = 0; i < particleCount; ++i) {
                double x = pEntity.m_20185_() + (double)Mth.m_216283_((RandomSource)pEntity.m_217043_(), (float)-0.7f, (float)0.7f);
                double y = pEntity.m_20186_();
                double z = pEntity.m_20189_() + (double)Mth.m_216283_((RandomSource)pEntity.m_217043_(), (float)-0.7f, (float)0.7f);
                pLevel.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void generateDustParticles(LivingEntity pEntity, float pRed, float pGreen, float pBlue, float pAmount, boolean isCustomYNeeded, boolean isEyeHeight) {
        Vector3f color = new Vector3f(pRed, pGreen, pBlue);
        DustParticleOptions particles = new DustParticleOptions(color, pAmount);
        double y = isCustomYNeeded ? (isEyeHeight ? pEntity.m_20188_() : (double)pEntity.m_20206_()) : pEntity.m_20186_();
        for (int i = 0; i < 3; ++i) {
            double x = pEntity.m_20185_() + (pEntity.m_217043_().m_188500_() - 0.5) * 1.2;
            double z = pEntity.m_20189_() + (pEntity.m_217043_().m_188500_() - 0.5) * 1.2;
            pEntity.m_9236_().m_7106_((ParticleOptions)particles, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void generateCircleParticles(LivingEntity pEntity, int pParticleCount, SimpleParticleType pType, boolean isCustomYNeeded, boolean isEyeHeight, double pXSpeed, double pYSpeed, double pZSpeed, double radius, double rotationSpeed) {
        double centerX = pEntity.m_20185_();
        double centerY = isCustomYNeeded ? (isEyeHeight ? pEntity.m_20188_() : pEntity.m_20186_()) : pEntity.m_20186_() - 0.1;
        double centerZ = pEntity.m_20189_();
        rotationAngle += rotationSpeed;
        for (int i = 0; i < pParticleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)pParticleCount + rotationAngle;
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double particleX = centerX + xOffset;
            double particleZ = centerZ + zOffset;
            pEntity.m_9236_().m_7106_((ParticleOptions)pType, particleX, centerY, particleZ, pXSpeed, pYSpeed, pZSpeed);
        }
    }

    public static void generateCircleParticles(Level pLevel, LivingEntity pEntity, SimpleParticleType pType, double pRadius, double pRotationSpeed) {
        int particleCount = 5;
        double centerX = pEntity.m_20185_();
        double centerY = pEntity.m_20186_() + 0.2;
        double centerZ = pEntity.m_20189_();
        rotationAngle += pRotationSpeed;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount + rotationAngle;
            double xOffset = Math.cos(angle) * pRadius;
            double zOffset = Math.sin(angle) * pRadius;
            double x = centerX + xOffset;
            double z = centerZ + zOffset;
            pLevel.m_7106_((ParticleOptions)pType, x, centerY, z, 0.0, 0.0, 0.0);
        }
    }

    public static void generatePetrifiedParticles(LivingEntity pEntity) {
        for (int i = 0; i < 20; ++i) {
            double offsetX = pEntity.m_217043_().m_188500_() - 0.5;
            double offsetY = pEntity.m_217043_().m_188500_() - 0.25;
            double offsetZ = pEntity.m_217043_().m_188500_() - 0.5;
            double x = pEntity.m_20185_();
            double y = pEntity.m_20188_();
            double z = pEntity.m_20189_();
            pEntity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123783_, x + offsetX, y + offsetY, z + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public static void generateShockwaveParticles(Level level, LivingEntity pEntity, double pRadius) {
        BlockState block = level.m_8055_(pEntity.m_20183_().m_7495_());
        for (int i = 0; i < 100; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / 100.0);
            double x = pEntity.m_20185_() + pRadius * (double)Mth.m_14031_((float)angle);
            double y = pEntity.m_20186_() + 0.2;
            double z = pEntity.m_20189_() + pRadius * (double)Mth.m_14089_((float)angle);
            double ySpeed = level.m_213780_().m_188583_() * 0.2;
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), x, y, z, 0.0, ySpeed, 0.0);
        }
    }

    public static void generateUmbralDoomOrbTrail(Level pLevel, int growTimer, Entity pEntity) {
        int particleCount = 15;
        double centerX = pEntity.m_20185_() + pEntity.m_9236_().m_213780_().m_188500_() - 0.5;
        double centerY = pEntity.m_20186_() + pEntity.m_9236_().m_213780_().m_188500_() - 0.5;
        double centerZ = pEntity.m_20189_() + pEntity.m_9236_().m_213780_().m_188500_() - 0.5;
        for (int i = 0; i < particleCount; ++i) {
            pLevel.m_7106_((ParticleOptions)MLParticles.SKULL_PARTICLES.get(), centerX, centerY, centerZ, 0.0, 0.0, 0.0);
        }
    }

    public static void generateSkullParticles(Entity pEntity) {
        double y = pEntity.m_20186_() + 0.2;
        for (int i = 0; i < 3; ++i) {
            double x = pEntity.m_20185_() + (pEntity.m_9236_().m_213780_().m_188500_() - 0.5) * 2.0;
            double z = pEntity.m_20189_() + (pEntity.m_9236_().m_213780_().m_188500_() - 0.5) * 2.0;
            pEntity.m_9236_().m_7106_((ParticleOptions)MLParticles.SKULL_PARTICLES.get(), x, y, z, 0.0, 1.0, 0.0);
        }
    }

    public static void generateLampadBoostParticles(Level pLevel, LivingEntity pEntity) {
        double centerX = pEntity.m_20185_();
        double centerY = pEntity.m_20186_() + 0.5;
        double centerZ = pEntity.m_20189_();
        double maxRadius = 0.5;
        int particleCount = 100;
        double heightIncrement = 0.05;
        int rotations = 3;
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)particleCount;
            double angle = Math.PI * 2 * (double)rotations * progress;
            double radius = maxRadius;
            double particleX = centerX + radius * Math.cos(angle);
            double particleZ = centerZ + radius * Math.sin(angle);
            double particleY = centerY + (double)i * heightIncrement;
            pLevel.m_7106_((ParticleOptions)MLParticles.LAMPAD_BOOST_PARTICLE.get(), particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
    }

    public static void generateChargeParticles(Level pLevel, Entity pEntity) {
        for (int i = 0; i < 360; i += 40) {
            double x = pEntity.m_20185_() + Math.cos(Math.toRadians(i)) * 1.5;
            double z = pEntity.m_20189_() + Math.sin(Math.toRadians(i)) * 1.5;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123756_, x, pEntity.m_20186_() + 0.5, z, 0.0, 0.5, 0.0);
        }
    }

    public static void generateFallingParticles(Level pLevel, LivingEntity pEntity) {
        for (int i = 0; i < 100; ++i) {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123744_, pEntity.m_20185_() + pEntity.m_217043_().m_188583_() * 0.5, pEntity.m_20186_(), pEntity.m_20189_() + pEntity.m_217043_().m_188583_() * 0.5, 0.0, -0.1, 0.0);
        }
    }

    public static void generateStompParticles(Level pLevel, LivingEntity pEntity) {
        pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123756_, pEntity.m_20185_() * 0.2, pEntity.m_20186_(), pEntity.m_20189_() * 0.2, 0.2, -0.1, 0.2);
    }

    public static void generateLandingParticles(Level pLevel, LivingEntity pEntity) {
        int particleCount = 45;
        double radius = 3.5;
        double yOffset = 0.2;
        for (int i = 0; i < particleCount; ++i) {
            double angle = pEntity.m_217043_().m_188500_() * Math.PI * 2.0;
            double distance = pEntity.m_217043_().m_188500_() * radius;
            double x = pEntity.m_20185_() + Math.cos(angle) * distance;
            double y = pEntity.m_20186_() + yOffset;
            double z = pEntity.m_20189_() + Math.sin(angle) * distance;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, 0.0, 0.0, 0.1);
        }
    }

    public static void generateStunParticles(Level pLevel, LivingEntity pEntity) {
        int particleCount = 10;
        int rotationSpeed = 2;
        double radius = 0.5;
        double centerX = pEntity.m_20185_();
        double centerY = pEntity.m_20188_() + 0.5;
        double centerZ = pEntity.m_20189_();
        rotationAngle += (double)rotationSpeed;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount + rotationAngle;
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double particleX = centerX + xOffset;
            double particleZ = centerZ + zOffset;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123797_, particleX, centerY, particleZ, 0.0, 0.1, 0.0);
        }
    }

    public static void generateHealingParticles(Level pLevel, LivingEntity pEntity) {
        pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123750_, pEntity.m_20185_(), pEntity.m_20186_() + 2.0, pEntity.m_20189_(), 0.5, 0.5, 0.5);
    }

    public static void generateHeadParticles(Level pLevel, Vector3d pPos) {
        pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123744_, pPos.x, pPos.y, pPos.z, 0.0, 0.1, 0.0);
    }

    public static void generateProjectileTrail(Level pLevel, Entity pEntity, ParticleOptions pParticle) {
        int particleCount = 1;
        double centerX = pEntity.m_20185_() + pEntity.m_9236_().m_213780_().m_188500_() - 0.5;
        double centerY = pEntity.m_20186_() + pEntity.m_9236_().m_213780_().m_188500_() - 0.5;
        double centerZ = pEntity.m_20189_() + pEntity.m_9236_().m_213780_().m_188500_() - 0.5;
        for (int i = 0; i < particleCount; ++i) {
            pLevel.m_7106_(pParticle, centerX, centerY, centerZ, 0.0, 0.0, 0.0);
        }
    }
}

