/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.analysis.LocalVariableLookup;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.transformer.param.TransformParameters;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.MethodQualifier;
import org.sinytra.adapter.patch.util.OpcodeUtil;

public record ModifyRedirectToWrapper(MethodQualifier originalTarget, MethodQualifier newTarget) implements MethodTransform
{
    private static final Type OPERATION_TYPE = Type.getObjectType((String)"com/llamalad7/mixinextras/injector/wrapoperation/Operation");

    @Override
    public Collection<String> getAcceptedAnnotations() {
        return Set.of("Lorg/spongepowered/asm/mixin/injection/Redirect;");
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        Object[] objectArray;
        LocalVariableLookup lookup = new LocalVariableLookup(methodNode);
        Type newOwnerType = Type.getType((String)this.newTarget.owner());
        boolean sameOwnerType = Type.getType((String)this.originalTarget.owner()).equals((Object)newOwnerType);
        int offset = ((methodNode.access & 8) == 0 ? 1 : 0) + (!sameOwnerType ? -1 : 0);
        Set paramLvtIndices = IntStream.range(offset + 1, Type.getArgumentTypes((String)methodNode.desc).length + offset).map(i -> lookup.getByOrdinal((int)i).index).boxed().collect(Collectors.toSet());
        List<List<AbstractInsnNode>> insns = MethodCallAnalyzer.getInvocationInsns(methodNode, this.originalTarget);
        if (insns.isEmpty()) {
            return Patch.Result.PASS;
        }
        List flatInsns = insns.stream().flatMap(Collection::stream).toList();
        Set loadedLocals = insns.stream().map(i -> {
            Integer n;
            if (i instanceof VarInsnNode) {
                VarInsnNode varInsn = (VarInsnNode)i;
                n = varInsn.var;
            } else {
                n = null;
            }
            return n;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        for (AbstractInsnNode insn : methodNode.instructions) {
            if (!(insn instanceof VarInsnNode)) continue;
            VarInsnNode varInsn = (VarInsnNode)insn;
            if (!paramLvtIndices.contains(varInsn.var) || loadedLocals.contains(varInsn.var) || flatInsns.contains(insn)) continue;
            return Patch.Result.PASS;
        }
        TransformParameters removeOldParamsPatch = TransformParameters.builder().chain(b -> {
            for (int i = Type.getArgumentTypes((String)methodNode.desc).length - 1; i >= offset; --i) {
                b.remove(i);
            }
        }).build();
        removeOldParamsPatch.apply(classNode, methodNode, methodContext, context);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (sameOwnerType) {
            objectArray = new Type[]{};
        } else {
            Type[] typeArray = new Type[1];
            objectArray = typeArray;
            typeArray[0] = newOwnerType;
        }
        List args = Lists.reverse((List)builder.add(objectArray).add((Object[])Type.getArgumentTypes((String)this.newTarget.desc())).build());
        TransformParameters addNewParamsPatch = TransformParameters.builder().chain(b -> {
            for (int i = 0; i < args.size(); ++i) {
                Type type = (Type)args.get(i);
                b.inject(i, type);
            }
            b.inject(args.size(), OPERATION_TYPE);
        }).build();
        addNewParamsPatch.apply(classNode, methodNode, methodContext, context);
        LocalVariableLookup updatedLookup = new LocalVariableLookup(methodNode);
        LocalVariableNode operationVar = updatedLookup.getForType(OPERATION_TYPE).get(0);
        int operationParamOrdinal = updatedLookup.getOrdinal(operationVar);
        ArrayList<LocalVariableNode> localVars = new ArrayList<LocalVariableNode>();
        for (int i2 = 1; i2 < operationParamOrdinal; ++i2) {
            localVars.add(updatedLookup.getByOrdinal(i2));
        }
        InsnList originalCallInsns = AdapterUtil.insnsWithAdapter(a -> {
            a.load(operationVar.index, OPERATION_TYPE);
            a.iconst(localVars.size());
            a.newarray(Type.getObjectType((String)"java/lang/Object"));
            for (int i = 0; i < localVars.size(); ++i) {
                LocalVariableNode lvn = (LocalVariableNode)localVars.get(i);
                Type type = Type.getType((String)lvn.desc);
                a.dup();
                a.iconst(i);
                a.load(lvn.index, type);
                a.visitInsn(83);
            }
            a.invokeinterface("com/llamalad7/mixinextras/injector/wrapoperation/Operation", "call", "([Ljava/lang/Object;)Ljava/lang/Object;");
            OpcodeUtil.castObjectType(Type.getReturnType((String)this.newTarget.desc()), (MethodVisitor)a);
        });
        for (List<AbstractInsnNode> list : insns) {
            methodNode.instructions.insertBefore(list.get(0), originalCallInsns);
            list.forEach(arg_0 -> ((InsnList)methodNode.instructions).remove(arg_0));
        }
        return Patch.Result.APPLY;
    }
}

